/*
https://dist.torproject.org/torbrowser/8.0.3/tor-win32-0.3.4.8.zip
https://dist.torproject.org/torbrowser/8.0.3/tor-win64-0.3.4.8.zip
https://dist.torproject.org/torbrowser/8.5a3/tor-win32-0.3.5.2-alpha.zip
https://dist.torproject.org/torbrowser/8.5a3/tor-win64-0.3.5.2-alpha.zip
https://dist.torproject.org/torbrowser/8.5a2/tor-win32-0.3.5.2-alpha.zip

https://www.torproject.org/dist/win32/tor-0.2.4.23-win32.exe
https://otr.cypherpunks.ca/binaries/windows/pidgin-otr-4.0.0-1.exe
https://otr.cypherpunks.ca/binaries/windows/pidgin-otr-4.0.2.exe
*/
; !define TEST
!define RELEASURL	"https://dist.torproject.org/torbrowser"
!define PIDGINSURL	"https://otr.cypherpunks.ca/binaries/windows/pidgin-otr-4.0.2.exe"
; !define APPSIZE	"15400" # kB
!define 7Z ; Delete if setup not 7z
!define DLVER	"MultiVersion"
!define APPVER 	"0.0.0.0"
!define APPNAME "Tor"
!define APP 	"Tor"
!define DLNAME	"Tor"
!define APPLANG	"32-64-bit_Online"
!define FOLDER	"TorPortable"
!define FINISHRUN ; Delete if not Finish pages
!define OPTIONS ; Delete if no Components
; !define DESCRIPTION	"Anonimity online" ; Delete if no AppInfo
!define INPUTBOX ; Delete if no InputBox
!define SOURCES ; Delete if no Sources

SetCompressor /SOLID lzma
SetCompressorDictSize 32

!include "..\_Include\Installer.nsh"
!include "LogicLib.nsh"
!include "x64.nsh"

!insertmacro MUI_LANGUAGE "English"
!insertmacro MUI_LANGUAGE "French"
!insertmacro MUI_LANGUAGE "Arabic"
!insertmacro MUI_LANGUAGE "German"
!insertmacro MUI_LANGUAGE "Spanish"
!insertmacro MUI_LANGUAGE "Italian"
!insertmacro MUI_LANGUAGE "PortugueseBR"
!insertmacro MUI_LANGUAGE "SimpChinese"
!insertmacro MUI_LANGUAGE "Russian"
!insertmacro MUI_LANGUAGE "Dutch"
!insertmacro MUI_LANGUAGE "Farsi"

Var InputVer
Var VER
Var InputBrowserVer
Var BROWSERVER
Function nsDialogsPage
	nsDialogs::Create 1018
	Pop $0
	${NSD_CreateLabel} 0 0 100% 12u "Enter Tor Version Number:"
	Pop $0
	${NSD_CreateText} 0 13u 100% 12u ""
	Pop $InputVer
	${NSD_CreateLabel} 0 50u 100% 12u "Enter TorBrowser Version Number:"
	Pop $0
	${NSD_CreateText} 0 63u 100% 12u ""
	Pop $InputBrowserVer
	nsDialogs::Show
FunctionEnd
Function nsDialogsPageLeave
	${NSD_GetText} $InputVer $R0
StrCmp $R0 "" 0 +3
	MessageBox MB_ICONEXCLAMATION `You must enter Tor version number!`
Abort
	StrCpy $VER "$R0"
	${NSD_GetText} $InputBrowserVer $R0
StrCmp $R0 "" 0 +3
	MessageBox MB_ICONEXCLAMATION `You must enter Browser version number!`
Abort
	StrCpy $BROWSERVER "$R0"
FunctionEnd

Section /o "${APPNAME} Portable 32 bit" x32
; SectionIn RO
	SetOutPath "$INSTDIR\App"
DetailPrint "Installing ${APPNAME} Portable 32 bit"
${If} ${FileExists} "$EXEDIR\tor-win32-$VER.zip"
	nsExec::Exec `"$TEMP\${APP}PortableTemp\7z.exe" x "$EXEDIR\tor-win32-$VER.zip" -aoa -o"$INSTDIR\App"`
${Else}
Call CheckConnected
	inetc::get "${RELEASURL}/$BROWSERVER/tor-win32-$VER.zip" "$TEMP\${APP}PortableTemp\tor-win32-$VER.zip" /END
	Pop $0
StrCmp $0 "OK" +3
	MessageBox MB_ICONEXCLAMATION "tor-win32-$VER.zip not found in $EXEDIR and download: $0"
	Abort
	nsExec::Exec `"$TEMP\${APP}PortableTemp\7z.exe" x "$TEMP\${APP}PortableTemp\tor-win32-$VER.zip" -aoa -o"$INSTDIR\App"`
${EndIf}
DetailPrint "Installing ${APPNAME} Portable 32 bit"

	SetOutPath "$INSTDIR"
		File "..\..\..\${FOLDER}\${APP}Portable.exe"

	SetOutPath "$INSTDIR\App\${APP}"
	File "${APP}.ico"

SectionEnd

Function .onGUIEnd
!ifdef DESCRIPTION
Call AppInfo
!endif
!ifdef SOURCES
Call Sources
	SetOutPath "$INSTDIR\Other\_Include\7-Zip"
	File "..\_Include\7-Zip\7z.exe"
	File "..\_Include\7-Zip\7z.dll"
	SetOutPath "$INSTDIR\Other\Source"
	File "_FirefoxTorPortable.nsi"
	File "_PaleMoonTorPortable.nsi"
	File "_OperaTorPortable.nsi"
	File "_PidginTorPortable.nsi"
	File "_SeaMonkeyTorPortable.nsi"
	File "_ThunderbirdTorPortable.nsi"
	File "FirefoxTor.ico"
	File "PaleMoonTor.ico"
	File "OperaTor.ico"
	File "PidginTor.ico"
	File "SeaMonkeyTor.ico"
	File "ThunderbirdTor.ico"
	File "prefs.js"
	File "prefs.xml"
	File "ThunderbirdTor.js"
!endif
!ifdef SOURCES & DESCRIPTION
Call SourceInfo
!endif
!ifndef TEST
	RMDir "/r" "$TEMP\${APP}PortableTemp"
!endif
FunctionEnd

Section /o "${APPNAME} Portable 64 bit" x64

	SetOutPath "$INSTDIR\Temp"
DetailPrint "Installing ${APPNAME} Portable 64 bit"
${If} ${FileExists} "$EXEDIR\tor-win64-$VER.zip"
	nsExec::Exec `"$TEMP\${APP}PortableTemp\7z.exe" x "$EXEDIR\tor-win64-$VER.zip" -aoa -o"$INSTDIR\Temp"`
${Else}
Call CheckConnected
	inetc::get "${RELEASURL}/$BROWSERVER/tor-win64-$VER.zip" "$TEMP\${APP}PortableTemp\tor-win64-$VER.zip" /END
	Pop $0
StrCmp $0 "OK" +3
	MessageBox MB_ICONEXCLAMATION "tor-win64-$VER.zip not found in $EXEDIR and download: $0"
	Abort
	nsExec::Exec `"$TEMP\${APP}PortableTemp\7z.exe" x "$TEMP\${APP}PortableTemp\tor-win64-$VER.zip" -aoa -o"$INSTDIR\Temp"`
${EndIf}
DetailPrint "Installing ${APPNAME} Portable 64 bit"

	SetOutPath "$INSTDIR"
		File "..\..\..\${FOLDER}\${APP}Portable.exe"
	SetOutPath "$INSTDIR\App"
	RMDir "/r" "$INSTDIR\App\Data"
	Rename "$INSTDIR\Temp\Data" "$INSTDIR\App\Data"
	RMDir "/r" "$INSTDIR\App\${APP}64"
	Rename "$INSTDIR\Temp\${APP}"  "$INSTDIR\App\${APP}64"
	SetOutPath "$INSTDIR\App\${APP}64"
	File "${APP}.ico"
	RMDir "/r" "$INSTDIR\Temp"

SectionEnd

Section /o "Firefox for Tor Portable" firefox
SectionIn RO
	SetOutPath "$MAINPATH\FirefoxPortable"
	File "..\..\..\FirefoxPortable\FirefoxTorPortable.exe"
SectionEnd

Section /o "Opera for Tor Portable" opera
SectionIn RO
	SetOutPath "$MAINPATH\OperaPortable"
	File "..\..\..\OperaPortable\OperaTorPortable.exe"
SectionEnd

Section /o "PaleMoon for Tor Portable" palemoon
SectionIn RO
	SetOutPath "$MAINPATH\FirefoxPortable"
	File "..\..\..\FirefoxPortable\PaleMoonTorPortable.exe"
SectionEnd

Section /o "SeaMonkey for Tor Portable" seamonkey
SectionIn RO
	SetOutPath "$MAINPATH\SeaMonkeyPortable"
	File "..\..\..\SeaMonkeyPortable\SeaMonkeyTorPortable.exe"
SectionEnd

Section /o "Thunderbird for Tor Portable" thunderbird
SectionIn RO
	SetOutPath "$MAINPATH\ThunderbirdPortable"
	File "..\..\..\ThunderbirdPortable\ThunderbirdTorPortable.exe"
SectionEnd

Section /o "Pidgin for Tor Portable" pidgin
SectionIn RO
	SetOutPath "$MAINPATH\PidginPortable"
	File "..\..\..\PidginPortable\PidginTorPortable.exe"
	inetc::get "${PIDGINSURL}" "$TEMP\${APP}PortableTemp\pidgin-otr.exe" /END
	Pop $0
StrCmp $0 "OK" +3
	MessageBox MB_ICONEXCLAMATION "Download pidgin-otr.exe: $0"
	Abort
	nsExec::Exec `"$TEMP\${APP}PortableTemp\7z.exe" x "$TEMP\${APP}PortableTemp\pidgin-otr.exe" -aoa -o"$TEMP\${APP}PortableTemp\pidgin-otr"`

	SetOutPath "$MAINPATH\PidginPortable\App\Pidgin\plugins"
	CopyFiles /SILENT "$TEMP\${APP}PortableTemp\pidgin-otr\pidgin-otr.dll" "$MAINPATH\PidginPortable\App\Pidgin\plugins"
SectionEnd


Function Init
SectionSetSize ${x32} 16000 # kB
SectionSetSize ${x64} 16000 # kB
${If} ${RunningX64}
	SectionSetFlags ${x64} 1
${Else}
	SectionSetFlags ${x32} 1
${EndIf}

IfFileExists "$MAINPATH\PidginPortable\PidginPortable.exe" 0 +2
SectionSetFlags ${pidgin} 17
IfFileExists "$MAINPATH\FirefoxPortable\FirefoxPortable.exe" 0 +2
SectionSetFlags ${firefox} 17
IfFileExists "$MAINPATH\FirefoxPortable\PaleMoonPortable.exe" 0 +2
SectionSetFlags ${palemoon} 17
IfFileExists "$MAINPATH\ThunderbirdPortable\ThunderbirdPortable.exe" 0 +2
SectionSetFlags ${thunderbird} 17
IfFileExists "$MAINPATH\OperaPortable\OperaPortable.exe" 0 +2
SectionSetFlags ${opera} 17
IfFileExists "$MAINPATH\SeaMonkeyPortable\SeaMonkeyPortable.exe" 0 +2
SectionSetFlags ${seamonkey} 17
FunctionEnd
