/*
c:\Users\Admin\AppData\Roaming\tor\
*/
; **************************************************************************
; === Define constants ===
; **************************************************************************
!define VER 		"0.0.0.0"	; version of launcher
!define APPNAME 	"Tor"	; complete name of program
!define APP 		"Tor"	; short name of program without space and accent  this one is used for the final executable an in the directory structure
!define APPEXE 		"tor.exe"	; main exe name
!define APPDIR 		"App\Tor"	; main exe relative path
!define APPEXE64 	"tor.exe"	; main exe 64 bit name
!define APPDIR64 	"App\Tor64"	; main exe 64 bit relative path

; **************************************************************************
; === Best Compression ===
; **************************************************************************
SetCompressor /SOLID lzma
SetCompressorDictSize 32

; **************************************************************************
; === Includes ===
; **************************************************************************
!include "..\_Include\Launcher.nsh" 
!include "LogicLib.nsh"
!include "x64.nsh"

; **************************************************************************
; === Set basic information ===
; **************************************************************************
Name "${APPNAME} Portable"
OutFile "..\..\..\${APP}Portable\${APP}Portable.exe"
Icon "${APP}.ico"

; **************************************************************************
; === Other Actions ===
; **************************************************************************
Function Init

; IfFileExists "$EXEDIR\Data\${APP}\geoip" +3
CreateDirectory "$EXEDIR\Data\${APP}"
; CopyFiles /SILENT "$EXEDIR\App\DefaultData\${APP}\geoip" "$EXEDIR\Data\${APP}"
; CopyFiles /SILENT "$EXEDIR\App\DefaultData\${APP}\geoip6" "$EXEDIR\Data\${APP}"
FileOpen $0 "$EXEDIR\Data\${APP}\torrc" w
FileWrite $0 "DataDirectory $EXEDIR\Data\${APP}$\r$\n"
FileWrite $0 "GeoIPFile $EXEDIR\App\Data\${APP}\geoip$\r$\n"
FileWrite $0 "GeoIPv6File $EXEDIR\App\Data\${APP}\geoip6$\r$\n"
FileWrite $0 "HiddenServiceStatistics 0$\r$\n"
FileClose $0

FunctionEnd

Function Close

FunctionEnd


; **************************************************************************
; ==== Running ====
; **************************************************************************

Section "Main"

	Call CheckStart

	Call Init

		Call SplashLogo
		Call Launch

	Call Restore

SectionEnd

Function Restore

	Call Close

FunctionEnd

; **************************************************************************
; === Run Application ===
; **************************************************************************
Function Launch
${If} ${RunningX64}
${AndIf} ${FileExists} "$EXEDIR\${APPDIR64}\${APPEXE64}"
SetOutPath "$EXEDIR\${APPDIR64}"
CreateShortCut 	"$EXEDIR\${APPDIR64}\${APP}.lnk" "$EXEDIR\${APPDIR64}\${APPEXE64}" "-f $EXEDIR\Data\${APP}\torrc" "$EXEDIR\${APPDIR64}\${APP}.ico" 0
ExecShell "open" "$EXEDIR\${APPDIR64}\${APP}.lnk"
	FindProcDLL::WaitProcEnd "${APPEXE64}" -1
${Else}
SetOutPath "$EXEDIR\${APPDIR}"
CreateShortCut 	"$EXEDIR\${APPDIR}\${APP}.lnk" "$EXEDIR\${APPDIR}\${APPEXE}" "-f $EXEDIR\Data\${APP}\torrc" "$EXEDIR\${APPDIR}\${APP}.ico" 0
ExecShell "open" "$EXEDIR\${APPDIR}\${APP}.lnk"
	FindProcDLL::WaitProcEnd "${APPEXE}" -1
${EndIf}

WriteINIStr "$EXEDIR\Data\${APP}Portable.ini" "${APP}Portable" "GoodExit" "true"
newadvsplash::stop
Delete "$EXEDIR\\${APPDIR}\${APP}.lnk"
Delete "$EXEDIR\\${APPDIR64}\${APP}.lnk"

FunctionEnd
