; **************************************************************************
; === Define constants ===
; **************************************************************************
!define VER "0.0.0.0"
!define APPNAME "Mozilla Thunderbird for Tor"
!define APP "Thunderbird"
!define APPDIR "App\Thunderbird"
!define APPEXE "thunderbird.exe"
!define APPSWITCH ` -profile "$EXEDIR\Data\ProfileTor"` 

; --- Define RegKeys ---
	!define REGKEY1 "HKEY_LOCAL_MACHINE\SOFTWARE\Mozilla"
	!define REGKEY2 "HKEY_CURRENT_USER\Software\Microsoft\Windows\CurrentVersion\UnreadMail"
	!define REGKEY3 "HKEY_LOCAL_MACHINE\SOFTWARE\Classes\http\shell\open\command"
	!define REGKEY4 "HKEY_LOCAL_MACHINE\SOFTWARE\Classes\https\shell\open\command"
	!define REGKEY5 "HKEY_LOCAL_MACHINE\SOFTWARE\Classes\ftp\shell\open\command"
	!define REGKEY6 "HKEY_LOCAL_MACHINE\SOFTWARE\Clients\StartMenuInternet"

; **************************************************************************
; === Best Compression ===
; **************************************************************************
SetCompressor /SOLID lzma
SetCompressorDictSize 32

; **************************************************************************
; === Includes ===
; **************************************************************************
!include "..\_Include\Launcher.nsh"
!include "TextReplace.nsh"
!include "LogicLib.nsh"

; **************************************************************************
; === Set basic information ===
; **************************************************************************
Name "${APPNAME} Portable"
OutFile "..\..\..\${APP}Portable\${APP}TorPortable.exe"
Icon "${APP}Tor.ico"

; **************************************************************************
; === Other Actions ===
; **************************************************************************
Var PARENTDIR
Function Init
${If} ${FileExists} "$EXEDIR\Data\ProfileTor\prefs.js"
${Else}
	SetOutPath "$EXEDIR\Data\ProfileTor"
	File "/oname=$EXEDIR\Data\ProfileTor\prefs.js" "${APP}Tor.js"
	ReadINIStr $1 "$EXEDIR\${APPDIR}\application.ini" "App" "Version"
	FileOpen $0 "$EXEDIR\Data\ProfileTor\prefs.js" a
	IfErrors done
FileSeek $0 0 END
FileWrite $0 `user_pref("extensions.lastAppVersion", "$1");`
FileWriteByte $0 "13"
FileWriteByte $0 "10"
FileWrite $0 `user_pref("mailnews.start_page_override.mstone", "$1");`
FileWriteByte $0 "13"
FileWriteByte $0 "10"
FileClose $0
done:
${EndIf}

	${registry::BackupKey} "${REGKEY1}"
	${registry::BackupKey} "${REGKEY2}"

ReadINIStr $0 "$EXEDIR\Data\${APP}Portable.ini" "${APP}Portable" "LastDirectory"
StrCpy $1 $0 3
StrCpy $2 $EXEDIR 3
StrCmp $1 $2 +3
	${textreplace::ReplaceInFile} "$EXEDIR\Data\ProfileTor\prefs.js" "$EXEDIR\Data\ProfileTor\prefs.js" "$1" "$2" "" $0
	${textreplace::Unload}

nsisFirewall::AddAuthorizedApplication "$EXEDIR\${APPDIR}\${APPEXE}" "${APPNAME} Portable"
FunctionEnd

Function CheckInit
	ReadINIStr $0 "$EXEDIR\${APP}Portable.ini" "${APP}Portable" "FirefoxAssociate"
	StrCmp $0 "false" CheckInitEnd
	WriteINIStr "$EXEDIR\${APP}Portable.ini" "${APP}Portable" "FirefoxAssociate" "true"
${GetParent} "$EXEDIR" "$PARENTDIR"
	IfFileExists "$PARENTDIR\FirefoxPortable\App\Firefox\firefox.exe" RegFire
	Goto CheckInitEnd
	RegFire:
	${registry::BackupKey} "${REGKEY3}"
	${registry::BackupKey} "${REGKEY4}"
	${registry::BackupKey} "${REGKEY5}"
	${registry::BackupKey} "${REGKEY6}"
		Sleep 50
		WriteRegStr HKEY_LOCAL_MACHINE "SOFTWARE\Classes\HTTP\shell\open\command" "" `"$PARENTDIR\FirefoxPortable\App\Firefox\firefox.exe" -profile "$PARENTDIR\FirefoxPortable\Data\ProfileTor" -requestPending -url "%1"`
		WriteRegStr HKEY_LOCAL_MACHINE "SOFTWARE\Classes\https\shell\open\command" "" `"$PARENTDIR\FirefoxPortable\App\Firefox\firefox.exe" -profile "$PARENTDIR\FirefoxPortable\Data\ProfileTor" -requestPending -url "%1"`
		WriteRegStr HKEY_LOCAL_MACHINE "SOFTWARE\Classes\ftp\shell\open\command" "" `"$PARENTDIR\FirefoxPortable\App\Firefox\firefox.exe" -profile "$PARENTDIR\FirefoxPortable\Data\ProfileTor" -requestPending -url "%1"`
	CheckInitEnd:
FunctionEnd

Function Close
	nsisFirewall::RemoveAuthorizedApplication "$EXEDIR\${APPDIR}\${APPEXE}"
	${registry::RestoreBackupKey} "${REGKEY1}"
	${registry::RestoreBackupKey} "${REGKEY2}"
	
FunctionEnd

Function CheckClose
	ReadINIStr $0 "$EXEDIR\${APP}Portable.ini" "${APP}Portable" "FirefoxAssociate"
	StrCmp $0 "false" CheckCloseEnd
	IfFileExists "$PARENTDIR\FirefoxPortable\App\Firefox\firefox.exe" UnRegFire
	Goto CheckCloseEnd
	UnRegFire:
	${registry::RestoreBackupKey} "${REGKEY3}"
	${registry::RestoreBackupKey} "${REGKEY4}"
	${registry::RestoreBackupKey} "${REGKEY5}"
	${registry::RestoreBackupKey} "${REGKEY6}"
	CheckCloseEnd:
	Sleep 50
	${registry::Unload}
FunctionEnd

; **************************************************************************
; === Run Application ===
; **************************************************************************
Function Launch
SetOutPath "$EXEDIR\${APPDIR}"
${GetParameters} $0
ExecWait `"$EXEDIR\${APPDIR}\${APPEXE}"${APPSWITCH} $0`
WriteINIStr "$EXEDIR\Data\${APP}Portable.ini" "${APP}Portable" "GoodExit" "true"
newadvsplash::stop
FunctionEnd

; **************************************************************************
; ==== Running ====
; **************************************************************************

Section "Main"

	Call CheckStart

	Call Init
	Call CheckInit

		Call SplashLogo
		Call Launch

	Call Restore

SectionEnd

Function Restore

	Call Close
	Call CheckClose

FunctionEnd
