; **************************************************************************
; === Define constants ===
; **************************************************************************
!define VER 		"0.0.0.0"	; version of launcher
!define APPNAME 	"Mozilla SeaMonkey for Tor"	; complete name of program
!define APP 		"SeaMonkey"	; short name of program without space and accent  this one is used for the final executable an in the directory structure
!define APPEXE 		"seamonkey.exe"	; main exe name
!define APPDIR 		"App\SeaMonkey"	; main exe relative path
!define APPSWITCH 	` -profile "$EXEDIR\Data\ProfileTor"`	; some default Parameters

;--- Define RegKeys ---
	!define REGKEY1 "HKEY_LOCAL_MACHINE\SOFTWARE\Classes\MozillaPalmSync"
	!define REGKEY2 "HKEY_LOCAL_MACHINE\SOFTWARE\Classes\MozillaPalmSync.1"
	!define REGKEY3 "HKEY_LOCAL_MACHINE\SOFTWARE\Classes\CLSID\{B20B4521-CCF8-11D6-B8A5-000064657374}"
; ---Define Local Dirs, SubDirs (if any) beginnig with back-slash and Portable Dirs ---
	!define LOCALDIR1 "$APPDATA\Mozilla"
	!define SUBDIR1 "\SeaMonkey"
	!define PORTABLEDIR1 "$EXEDIR\Data\SeaMonkey"

; **************************************************************************
; === Best Compression ===
; **************************************************************************
SetCompressor /SOLID lzma
SetCompressorDictSize 32

; **************************************************************************
; === Includes ===
; **************************************************************************
!include "..\_Include\Launcher.nsh" 
!include "LogicLib.nsh"

; **************************************************************************
; === Set basic information ===
; **************************************************************************
Name "${APPNAME} Portable"
OutFile "..\..\..\${APP}Portable\${APP}TorPortable.exe"
Icon "${APP}Tor.ico"

; **************************************************************************
; === Other Actions ===
; **************************************************************************
Var PARENTDIR
Function Init
${If} ${FileExists} "$EXEDIR\Data\ProfileTor\prefs.js"
${Else}
	SetOutPath "$EXEDIR\Data\ProfileTor"
	File "prefs.js"
	File "bookmarks.html"
	ReadINIStr $1 "$EXEDIR\${APPDIR}\application.ini" "App" "Version"
	ReadINIStr $2 "$EXEDIR\${APPDIR}\application.ini" "Gecko" "MinVersion"
ClearErrors
	FileOpen $0 "$EXEDIR\Data\ProfileTor\prefs.js" a
	IfErrors done
	FileSeek $0 0 END
	FileWrite $0 `user_pref("extensions.lastAppVersion", "$1");`
	FileWriteByte $0 "13"
	FileWriteByte $0 "10"
FileWrite $0 `user_pref("browser.startup.homepage_override.mstone", "rv:$2");`
	FileWriteByte $0 "13"
	FileWriteByte $0 "10"
	FileClose $0
done:
${EndIf}

${GetParent} "$EXEDIR" "$PARENTDIR"
System::Call 'Kernel32::SetEnvironmentVariableA(t, t) i("MOZ_PLUGIN_PATH", "$EXEDIR\Data\Plugins;$PARENTDIR\CommonFiles\Plugins;$PARENTDIR\CommonFiles\Java\bin\plugin2").r0'

nsisFirewall::AddAuthorizedApplication "$EXEDIR\${APPDIR}\${APPEXE}" "${APPNAME} Portable"
FunctionEnd

Function Close
	nsisFirewall::RemoveAuthorizedApplication "$EXEDIR\${APPDIR}\${APPEXE}"
FunctionEnd

; **************************************************************************
; === Run Application ===
; **************************************************************************
Function Launch
ReadINIStr $1 "$EXEDIR\${APP}Portable.ini" "${APP}Portable" "AdditionalParameters"
StrCmp $1 "" 0 +2
WriteINIStr "$EXEDIR\${APP}Portable.ini" "${APP}Portable" "AdditionalParameters" ""
SetOutPath "$EXEDIR\${APPDIR}"
${GetParameters} $0
ExecWait `"$EXEDIR\${APPDIR}\${APPEXE}"${APPSWITCH} $0 $1`
	Sleep 1000
	FindProcDLL::FindProc "${APPEXE}"
		Pop $R0
		StrCmp $R0 "1" -3 +1
	WriteINIStr "$EXEDIR\Data\${APP}Portable.ini" "${APP}Portable" "GoodExit" "true"
newadvsplash::stop
FunctionEnd

; **************************************************************************
; ==== Actions on Registry Keys =====
; **************************************************************************
Function BackupLocalKeys
	${registry::BackupKey} "${REGKEY1}"
	${registry::BackupKey} "${REGKEY2}"
	${registry::BackupKey} "${REGKEY3}"
FunctionEnd

Function RestoreLocalKeys
	${registry::RestoreBackupKey} "${REGKEY1}"
	${registry::RestoreBackupKey} "${REGKEY2}"
	${registry::RestoreBackupKey} "${REGKEY3}"
${registry::Unload}
FunctionEnd

; **************************************************************************
; ==== Actions on Folders =====
; **************************************************************************
Function BackupLocalDirs
	RMDir "/r" "${LOCALDIR1}-BackupBy${APP}Portable"
	Rename "${LOCALDIR1}" "${LOCALDIR1}-BackupBy${APP}Portable"
FunctionEnd

Function RestorePortableDirs
	CreateDirectory "${LOCALDIR1}${SUBDIR1}"
	CopyFiles /SILENT "${PORTABLEDIR1}\*.*" "${LOCALDIR1}${SUBDIR1}"
FunctionEnd

Function BackupPortableDirs
	RMDir "/r" "${PORTABLEDIR1}"
	CreateDirectory "${PORTABLEDIR1}"
	CopyFiles /SILENT "${LOCALDIR1}${SUBDIR1}\*.*" "${PORTABLEDIR1}"
FunctionEnd

Function RestoreLocalDirs
	RMDir "/r" "${LOCALDIR1}"
	Rename "${LOCALDIR1}-BackupBy${APP}Portable" "${LOCALDIR1}"
FunctionEnd


; **************************************************************************
; ==== Running ====
; **************************************************************************
Function Restore

	Call Close

	Call BackupPortableDirs
	Call RestoreLocalDirs

	Call RestoreLocalKeys

FunctionEnd

Section "Main"

	Call CheckStart

	Call BackupLocalKeys

	Call BackupLocalDirs
	Call RestorePortableDirs

	Call Init

		Call SplashLogo
		Call Launch

	Call Restore

SectionEnd
