; **************************************************************************
; === Define constants ===
; **************************************************************************
!define VER 		"0.0.0.0"	; version of launcher
!define APPNAME 	"Pidgin for Tor"	; complete name of program
!define APP 		"Pidgin"	; short name of program without space and accent  this one is used for the final executable an in the directory structure
!define APPEXE 		"pidgin.exe"	; main exe name
!define APPDIR 		"App\Pidgin"	; main exe relative path
!define APPSWITCH 	` -c "$EXEDIR\Data\.purple"`	; some default Parameters

; **************************************************************************
; === Best Compression ===
; **************************************************************************
SetCompressor /SOLID lzma
SetCompressorDictSize 32

; **************************************************************************
; === Includes ===
; **************************************************************************
!include "..\_Include\Launcher.nsh" 
!include "TextReplace.nsh"

; **************************************************************************
; === Set basic information ===
; **************************************************************************
Name "${APPNAME} Portable"
OutFile "..\..\..\${APP}Portable\${APP}TorPortable.exe"
Icon "${APP}Tor.ico"


; **************************************************************************
; === Other Actions ===
; **************************************************************************
Function Init
IfFileExists "$EXEDIR\Data\${APP}Tor\prefs.xml" +3
CreateDirectory "$EXEDIR\Data\${APP}Tor"
File "/oname=$EXEDIR\Data\${APP}Tor\prefs.xml" "prefs.xml"
Rename "$EXEDIR\Data\.purple\prefs.xml" "$EXEDIR\Data\.purple\prefs.xml.BackupBy${APP}TorPortable"
Rename "$EXEDIR\Data\${APP}Tor\prefs.xml" "$EXEDIR\Data\.purple\prefs.xml"


ReadINIStr $0 "$EXEDIR\Data\${APP}Portable.ini" "${APP}Portable" "LastDirectory"
StrCpy $1 $0 3
StrCpy $2 $EXEDIR 3
StrCmp $1 $2 +4
	${textreplace::ReplaceInFile} "$EXEDIR\Data\.purple\prefs.xml" "$EXEDIR\Data\.purple\prefs.xml" "$1" "$2" "" $0
	${textreplace::ReplaceInFile} "$EXEDIR\Data\.purple\pounces.xml" "$EXEDIR\Data\.purple\pounces.xml" "$1" "$2" "" $0
	${textreplace::Unload}

	System::Call 'Kernel32::SetEnvironmentVariableA(t, t) i("PURPLEHOME", "$EXEDIR\Data").r0'
	StrCpy $0 "$EXEDIR\App\GTK\bin;$EXEDIR\${APPDIR}"
	System::Call 'Kernel32::SetEnvironmentVariableA(t, t) i("PATH", "$0").r0'
	System::Call 'Kernel32::SetEnvironmentVariableA(t, t) i("GTK_BASEPATH", "$EXEDIR\App\GTK").r0'

	System::Call 'Kernel32::SetEnvironmentVariableA(t, t) i("PIDGIN_NO_DLL_CHECK", "true").r0'
	System::Call 'Kernel32::SetEnvironmentVariableA(t, t) i("GAIM_NO_DLL_CHECK", "true").r0'
	System::Call 'Kernel32::SetEnvironmentVariableA(t, t) i("PURPLE_NO_DLL_CHECK", "true").r0'
	System::Call 'Kernel32::SetEnvironmentVariableA(t, t) i("PIDGIN_MULTI_INST", "1").r0'

FunctionEnd

Function Close
Rename "$EXEDIR\Data\.purple\prefs.xml" "$EXEDIR\Data\${APP}Tor\prefs.xml"
Rename "$EXEDIR\Data\.purple\prefs.xml.BackupBy${APP}TorPortable" "$EXEDIR\Data\.purple\prefs.xml"
FunctionEnd


; **************************************************************************
; ==== Running ====
; **************************************************************************

Section "Main"

	Call CheckDirExe
	Call CheckRunExe

	Call Init

		Call SplashLogo
		Call Launch

	Call Restore

SectionEnd

Function Restore

	Call Close

FunctionEnd

; **************************************************************************
; === Run Application ===
; **************************************************************************
Function Launch
ReadINIStr $1 "$EXEDIR\${APP}Portable.ini" "${APP}Portable" "AdditionalParameters"
StrCmp $1 "" 0 +2
WriteINIStr "$EXEDIR\${APP}Portable.ini" "${APP}Portable" "AdditionalParameters" ""
SetOutPath "$EXEDIR\${APPDIR}"
${GetParameters} $0
ExecWait `"$EXEDIR\${APPDIR}\${APPEXE}"${APPSWITCH} $0 $1`
WriteINIStr "$EXEDIR\Data\${APP}Portable.ini" "${APP}Portable" "GoodExit" "true"
newadvsplash::stop
FunctionEnd
