; **************************************************************************
; === Define constants ===
; **************************************************************************
!define VER "0.0.0.0"
!define APPNAME "Pale Moon for Tor"
!define APP "PaleMoon"
!define APPDIR "App\PaleMoon"
!define APPEXE "palemoon.exe"
!define APPDIR64 "App\PaleMoon64"
!define APPEXE64 "palemoon.exe"
!define APPSWITCH ` -profile "$EXEDIR\Data\${APP}Tor"`

;--- Define RegKeys ---
	!define REGKEYVALUE1 "HKEY_CLASSES_ROOT\mailto\shell\open\command"
	!define REGVALUE1 ""

; **************************************************************************
; === Best Compression ===
; **************************************************************************
SetCompressor /SOLID lzma
SetCompressorDictSize 32

; **************************************************************************
; === Includes ===
; **************************************************************************
!include "..\_Include\Launcher.nsh" 
!include "LogicLib.nsh"
!include "x64.nsh"
!include "FileFunc.nsh"

; **************************************************************************
; === Set basic information ===
; **************************************************************************
Name "${APPNAME} Portable"
OutFile "..\..\..\FirefoxPortable\${APP}TorPortable.exe"
Icon "${APP}Tor.ico"

; **************************************************************************
; === Other Actions ===
; **************************************************************************
Var PARENTDIR
Var THUNDERBIRDUSER
Var PLUGINPATH

Function Init
${If} ${FileExists} "$EXEDIR\Data\${APP}Tor\prefs.js"
${Else}
	SetOutPath "$EXEDIR\Data\${APP}Tor"
	File "prefs.js"
	File "bookmarks.html"
	ReadINIStr $1 "$EXEDIR\${APPDIR}\application.ini" "App" "Version"
	ReadINIStr $2 "$EXEDIR\${APPDIR}\application.ini" "Gecko" "MinVersion"
ClearErrors
	FileOpen $0 "$EXEDIR\Data\${APP}Tor\prefs.js" a
	IfErrors done
	FileSeek $0 0 END
	FileWrite $0 `user_pref("extensions.lastAppVersion", "$1");`
	FileWriteByte $0 "13"
	FileWriteByte $0 "10"
	FileWrite $0 `user_pref("browser.startup.homepage_override.mstone", "$2");`
	FileWriteByte $0 "13"
	FileWriteByte $0 "10"
	FileClose $0
done:
${EndIf}

	${GetParent} "$EXEDIR" "$PARENTDIR"
	StrCpy $PLUGINPATH "$EXEDIR\Data\Plugins;$PARENTDIR\CommonFiles\Plugins"
${If} ${RunningX64}
${AndIf} ${FileExists} "$EXEDIR\${APPDIR64}\${APPEXE64}"
IfFileExists "$PARENTDIR\CommonFiles\Java64\bin\plugin2\npjp2.dll" 0 +2
	StrCpy $PLUGINPATH "$PLUGINPATH;$PARENTDIR\CommonFiles\Java64\bin\plugin2"
IfFileExists "$PARENTDIR\CommonFiles\Java_64\bin\plugin2\npjp2.dll" 0 +2
	StrCpy $PLUGINPATH "$PLUGINPATH;$PARENTDIR\CommonFiles\Java_64\bin\plugin2"
	nsisFirewall::AddAuthorizedApplication "$EXEDIR\${APPDIR64}\${APPEXE64}" "${APPNAME} Portable 64 bit"
${Else}
IfFileExists "$PARENTDIR\CommonFiles\Java\bin\plugin2\npjp2.dll" 0 +2
	StrCpy $PLUGINPATH "$PLUGINPATH;$PARENTDIR\CommonFiles\Java\bin\plugin2"
	nsisFirewall::AddAuthorizedApplication "$EXEDIR\${APPDIR}\${APPEXE}" "${APPNAME} Portable"
${EndIf}
System::Call 'Kernel32::SetEnvironmentVariableA(t, t) i("MOZ_PLUGIN_PATH", "$PLUGINPATH").r0'
FunctionEnd

Function CheckInit
	ReadINIStr $0 "$EXEDIR\${APP}Portable.ini" "${APP}Portable" "ThunderbirdAssociate"
	StrCmp $0 "false" CheckInitEnd
	WriteINIStr "$EXEDIR\${APP}Portable.ini" "${APP}Portable" "ThunderbirdAssociate" "true"
	IfFileExists "$PARENTDIR\ThunderbirdPortable\App\Thunderbird\thunderbird.exe" RegThunder
	Goto CheckInitEnd
RegThunder:
	${registry::BackupValue} "${REGKEYVALUE1}" "${REGVALUE1}"
	Sleep 50
	${registry::Unload}
ReadINIStr $THUNDERBIRDUSER "$PARENTDIR\ThunderbirdPortable\ThunderbirdPortable.ini" "ThunderbirdPortable" "User"
	WriteRegStr HKEY_CLASSES_ROOT "mailto\shell\open\command" "" `"$PARENTDIR\ThunderbirdPortable\App\Thunderbird\thunderbird.exe" -profile "$PARENTDIR\ThunderbirdPortable\Data\$THUNDERBIRDUSER" -compose "%1"`
CheckInitEnd:
FunctionEnd

;**********************************************************
Function Close
${If} ${RunningX64}
${AndIf} ${FileExists} "$EXEDIR\${APPDIR64}\${APPEXE64}"
	nsisFirewall::RemoveAuthorizedApplication "$EXEDIR\${APPDIR64}\${APPEXE64}"
${Else}
	nsisFirewall::RemoveAuthorizedApplication "$EXEDIR\${APPDIR}\${APPEXE}"
${EndIf}
FunctionEnd

Function CheckClose
	ReadINIStr $0 "$EXEDIR\${APP}Portable.ini" "${APP}Portable" "ThunderbirdAssociate"
	StrCmp $0 "false" CheckCloseEnd
	IfFileExists "$PARENTDIR\ThunderbirdPortable\App\Thunderbird\thunderbird.exe" UnRegThunder
	Goto CheckCloseEnd
UnRegThunder:
	${registry::RestoreBackupValue} "${REGKEYVALUE1}" "${REGVALUE1}"
	Sleep 50
	${registry::Unload}
CheckCloseEnd:
FunctionEnd

; **************************************************************************
; === Run Application ===
; **************************************************************************
Function Launch
${GetParameters} $0
${If} ${RunningX64}
${AndIf} ${FileExists} "$EXEDIR\${APPDIR64}\${APPEXE64}"
SetOutPath "$EXEDIR\${APPDIR64}"
ExecWait `"$EXEDIR\${APPDIR64}\${APPEXE64}"${APPSWITCH} $0`
${Else}
SetOutPath "$EXEDIR\${APPDIR}"
ExecWait `"$EXEDIR\${APPDIR}\${APPEXE}"${APPSWITCH} $0`
${EndIf}
WriteINIStr "$EXEDIR\Data\${APP}Portable.ini" "${APP}Portable" "GoodExit" "true"
newadvsplash::stop
FunctionEnd

; **************************************************************************
; ==== Running ====
; **************************************************************************

Section "Main"

	Call CheckStart

	Call Init
	Call CheckInit
	
		Call SplashLogo
		Call Launch

	Call Restore

SectionEnd

Function Restore

	Call Close
	Call CheckClose

FunctionEnd

