; **************************************************************************
; === Define constants ===
; **************************************************************************
!define VER "0.0.0.0"
!define APPNAME "Opera for Tor"
!define APP "Opera"
!define APPDIR "App\Opera"
!define APPEXE "opera.exe"
!define APPDIR64 "App\Opera_64"
!define APPEXE64 "opera.exe"
!define APPSWITCH ` /settings "$EXEDIR\Data\${APP}\profile\operator.ini"`

; --- Define RegKeys ---
	!define REGKEY1 "HKEY_CURRENT_USER\Software\Opera Software"

; **************************************************************************
; === Best Compression ===
; **************************************************************************
SetCompressor /SOLID lzma
SetCompressorDictSize 32

; **************************************************************************
; === Includes ===
; **************************************************************************
!include "..\_Include\Launcher.nsh" 
!include "LogicLib.nsh"
!include "x64.nsh"

; **************************************************************************
; === Set basic information ===
; **************************************************************************
Name "${APPNAME} Portable"
OutFile "..\..\..\OperaPortable\${APP}TorPortable.exe"
Icon "${APP}Tor.ico"

; **************************************************************************
; === Other Actions ===
; **************************************************************************
Var PARENTDIR
Function Init
${If} ${FileExists} "$EXEDIR\Data\${APP}\profile\operator.ini"

${Else}
CreateDirectory "$EXEDIR\Data\${APP}\profile"
ReadINIStr $0 "$EXEDIR\App\DefaultData\${APP}\profile\operaprefs.ini" "Install" "Newest Used Version"
WriteINIStr "$EXEDIR\Data\${APP}\profile\operator.ini" "Install" "Newest Used Version" "$0"
ReadINIStr $0 "$EXEDIR\App\DefaultData\${APP}\profile\operaprefs.ini" "Install" "Newest Used Beta Name"
WriteINIStr "$EXEDIR\Data\${APP}\profile\operator.ini" "Install" "Newest Used Beta Name" "$0"
CreateDirectory "$EXEDIR\Data\${APP}\mail"
${EndIf}

${If} ${RunningX64}
${AndIf} ${FileExists} "$EXEDIR\${APPDIR}_64\*.*"
SetRegView 64
WriteINIStr "$EXEDIR\${APPDIR}_64\operaprefs_default.ini" "System" "Multi User" "0"
WriteINIStr "$EXEDIR\${APPDIR}_64\operaprefs_default.ini" "User Prefs" "Opera Directory" "$EXEDIR\Data\${APP}\profile"
${Else}
WriteINIStr "$EXEDIR\${APPDIR}\operaprefs_default.ini" "System" "Multi User" "0"
WriteINIStr "$EXEDIR\${APPDIR}\operaprefs_default.ini" "User Prefs" "Opera Directory" "$EXEDIR\Data\${APP}\profile"
${EndIf}

WriteINIStr "$EXEDIR\Data\${APP}\profile\operator.ini" "User Prefs" "Opera Local Directory" "$EXEDIR\Data\${APP}\profile"
WriteINIStr "$EXEDIR\Data\${APP}\profile\operator.ini" "User Prefs" "Check For New Opera" "0"
WriteINIStr "$EXEDIR\Data\${APP}\profile\operator.ini" "User Prefs" "Title" "Portable Opera %v.%s"
WriteINIStr "$EXEDIR\Data\${APP}\profile\operator.ini" "User Prefs" "Level Of Update Automation" "0"
WriteINIStr "$EXEDIR\Data\${APP}\profile\operator.ini" "User Prefs" "Show Default Browser Dialog" "0"
WriteINIStr "$EXEDIR\Data\${APP}\profile\operator.ini" "State" "Run" "0"

WriteINIStr "$EXEDIR\Data\${APP}\profile\operator.ini" "Mail" "Mail Root Directory" "$EXEDIR\Data\${APP}\mail"
WriteINIStr "$EXEDIR\Data\${APP}\profile\operator.ini" "User Prefs" "Cache Directory4" "$TEMP\${APP}Portable\Cache"
WriteINIStr "$EXEDIR\Data\${APP}\profile\operator.ini" "User Prefs" "Operator Cache Directory4" "$TEMP\${APP}Portable\OpCache"
WriteINIStr "$EXEDIR\Data\${APP}\profile\operator.ini" "User Prefs" "Temporary Download Directory" "$TEMP\${APP}Portable\TempDownload"

WriteINIStr "$EXEDIR\Data\${APP}\profile\operator.ini" "Proxy" "Web Turbo Config File" "$EXEDIR\Data\${APP}\turbosettings.xml"

WriteINIStr "$EXEDIR\Data\${APP}\profile\operator.ini" "Disk Cache" "Empty On Exit" "1"
ReadINIStr $0 "$EXEDIR\${APP}Portable.ini" "${APP}Portable" "EmptyCacheOnExit"
WriteINIStr "$EXEDIR\${APP}Portable.ini" "${APP}Portable" "EmptyCacheOnExit" "true"
StrCmp $0 "false" +1 +3
	WriteINIStr "$EXEDIR\${APP}Portable.ini" "${APP}Portable" "EmptyCacheOnExit" "false"
	WriteINIStr "$EXEDIR\Data\${APP}\profile\operator.ini" "Disk Cache" "Empty On Exit" "0"

ReadINIStr $0 "$EXEDIR\${APP}Portable.ini" "${APP}Portable" "PortableOpenDir"
StrCmp $0 "false" +3
WriteINIStr "$EXEDIR\${APP}Portable.ini" "${APP}Portable" "PortableOpenDir" "true"
WriteINIStr "$EXEDIR\Data\${APP}\profile\operator.ini" "Saved Settings" "Save Dir" "$EXEDIR"

ReadINIStr $0 "$EXEDIR\${APP}Portable.ini" "${APP}Portable" "PortableSaveDir"
StrCmp $0 "false" +3
WriteINIStr "$EXEDIR\${APP}Portable.ini" "${APP}Portable" "PortableSaveDir" "true"
WriteINIStr "$EXEDIR\Data\${APP}\profile\operator.ini" "Saved Settings" "Open Dir" "$EXEDIR"


WriteRegStr HKEY_LOCAL_MACHINE "SYSTEM\CurrentControlSet\Services\SharedAccess\Parameters\FirewallPolicy\StandardProfile\AuthorizedApplications\List" "$EXEDIR\${APPDIR}\${APPEXE}" "$EXEDIR\${APPDIR}\${APPEXE}:*:Enabled:Opera"

; Plugins
${GetParent} "$EXEDIR" "$PARENTDIR"
${If} ${RunningX64}
${AndIf} ${FileExists} "$PARENTDIR\CommonFiles\Java_64\bin\plugin2\npjp2.dll"
WriteINIStr "$EXEDIR\Data\${APP}\profile\operator.ini" "User Prefs" "Plugin Path" "$EXEDIR\Data\Plugins;$PARENTDIR\CommonFiles\Plugins;$PARENTDIR\CommonFiles\Java_64\bin\plugin2"
${Else}
WriteINIStr "$EXEDIR\Data\${APP}\profile\operator.ini" "User Prefs" "Plugin Path" "$EXEDIR\Data\Plugins;$PARENTDIR\CommonFiles\Plugins;$PARENTDIR\CommonFiles\Java\bin\plugin2"
${EndIf}

;=== Tor ===

WriteINIStr "$EXEDIR\Data\${APP}\profile\operator.ini" "Proxy" "Convert No Proxy Servers" "0"
WriteINIStr "$EXEDIR\Data\${APP}\profile\operator.ini" "Proxy" "HTTP server" ""
WriteINIStr "$EXEDIR\Data\${APP}\profile\operator.ini" "Proxy" "HTTPS server" ""
WriteINIStr "$EXEDIR\Data\${APP}\profile\operator.ini" "Proxy" "FTP server" ""
WriteINIStr "$EXEDIR\Data\${APP}\profile\operator.ini" "Proxy" "SOCKS server" "127.0.0.1:9050"
WriteINIStr "$EXEDIR\Data\${APP}\profile\operator.ini" "Proxy" "Use Automatic Proxy Configuration" "0"
WriteINIStr "$EXEDIR\Data\${APP}\profile\operator.ini" "Proxy" "Use HTTP" "0"
WriteINIStr "$EXEDIR\Data\${APP}\profile\operator.ini" "Proxy" "Use HTTPS" "0"
WriteINIStr "$EXEDIR\Data\${APP}\profile\operator.ini" "Proxy" "Use FTP" "0"
WriteINIStr "$EXEDIR\Data\${APP}\profile\operator.ini" "Proxy" "Use SOCKS" "1"
WriteINIStr "$EXEDIR\Data\${APP}\profile\operator.ini" "User Prefs" "Home URL" "https://check.torproject.org"
WriteINIStr "$EXEDIR\Data\${APP}\profile\operator.ini" "User Prefs" "Startup Type" "2"

	nsisFirewall::AddAuthorizedApplication "$EXEDIR\${APPDIR}\${APPEXE}" "${APPNAME} Portable"

FunctionEnd

Function Close

ReadINIStr $0 "$EXEDIR\${APP}Portable.ini" "${APP}Portable" "EmptyCacheOnExit"
StrCmp $0 "false" +2 +1
RMDir "/r" "$TEMP\${APP}Portable"

DeleteINIStr "$EXEDIR\Data\${APP}\profile\operator.ini" "User Prefs" "Plugin Path"
DeleteINIStr "$EXEDIR\Data\${APP}\profile\operator.ini" "User Prefs" "Opera Local Directory"
DeleteINIStr "$EXEDIR\Data\${APP}\profile\operator.ini" "User Prefs" "Check For New Opera"
DeleteINIStr "$EXEDIR\Data\${APP}\profile\operator.ini" "User Prefs" "Title"
DeleteINIStr "$EXEDIR\Data\${APP}\profile\operator.ini" "User Prefs" "Level Of Update Automation"
DeleteINIStr "$EXEDIR\Data\${APP}\profile\operator.ini" "User Prefs" "Show Default Browser Dialog"
DeleteINIStr "$EXEDIR\Data\${APP}\profile\operator.ini" "State" "Run"
DeleteINIStr "$EXEDIR\Data\${APP}\profile\operator.ini" "Mail" "Mail Root Directory"
DeleteINIStr "$EXEDIR\Data\${APP}\profile\operator.ini" "User Prefs" "Cache Directory4"
DeleteINIStr "$EXEDIR\Data\${APP}\profile\operator.ini" "User Prefs" "Operator Cache Directory4"
DeleteINIStr "$EXEDIR\Data\${APP}\profile\operator.ini" "User Prefs" "Temporary Download Directory"
DeleteINIStr "$EXEDIR\Data\${APP}\profile\operator.ini" "Proxy" "Web Turbo Config File"

	nsisFirewall::RemoveAuthorizedApplication "$EXEDIR\${APPDIR}\${APPEXE}"

FunctionEnd

; **************************************************************************
; === Run Application ===
; **************************************************************************
Function Launch
${GetParameters} $0
${If} ${RunningX64}
${AndIf} ${FileExists} "$EXEDIR\${APPDIR}_64\*.*"
SetOutPath "$EXEDIR\${APPDIR}_64"
ExecWait `"$EXEDIR\${APPDIR}_64\${APPEXE}"${APPSWITCH} $0`
${Else}
SetOutPath "$EXEDIR\${APPDIR}"
ExecWait `"$EXEDIR\${APPDIR}\${APPEXE}"${APPSWITCH} $0`
${EndIf}
WriteINIStr "$EXEDIR\Data\${APP}Portable.ini" "${APP}Portable" "GoodExit" "true"
newadvsplash::stop
FunctionEnd

; **************************************************************************
; ==== Actions on Registry Keys =====
; **************************************************************************
Function BackupLocalKeys
	${registry::BackupKey} "${REGKEY1}"
FunctionEnd

Function RestoreLocalKeys
	${registry::RestoreBackupKey} "${REGKEY1}"
${registry::Unload}
FunctionEnd

; **************************************************************************
; ==== Running ====
; **************************************************************************

Section "Main"

	Call CheckStart

	Call BackupLocalKeys

	Call Init

		Call SplashLogo
		Call Launch

	Call Restore

SectionEnd

Function Restore

	Call Close

	Call RestoreLocalKeys

FunctionEnd
